using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Collections;

namespace DrawPolygon
{
    public partial class PolygonForm : Form
    {
        private ArrayList vertices= new ArrayList();
        private bool openPolygon = true;
        private Pen pen = new Pen(Color.Red);
        private SolidBrush brush = new SolidBrush(Color.Yellow);

        public PolygonForm()
        {
            InitializeComponent();
        }

        private void drawPanel_MouseDown(object sender, MouseEventArgs e)
        {
            vertices.Add(new Point(e.X, e.Y));
            drawPanel.Invalidate();
        }

        private void drawPanel_Paint(object sender, PaintEventArgs e)
        {
            Graphics graphics = e.Graphics;
            if (vertices.Count > 1)
            {
                Point[] verticesArray=(Point[])(vertices.ToArray(vertices[0].GetType()));

                if (openPolygon)
                {
                    graphics.DrawPolygon(pen, verticesArray);
                }
                else
                {
                    graphics.FillPolygon(brush, verticesArray);
                }
            }
        }

        private void clearButton_Click(object sender, EventArgs e)
        {
            vertices.Clear();
            drawPanel.Invalidate();
        }

        private void openPolygonSelectButton_CheckedChanged(object sender, EventArgs e)
        {
            openPolygon = true;
            drawPanel.Invalidate();
        }

        private void closedPolygonSelectButton_CheckedChanged(object sender, EventArgs e)
        {
            openPolygon = false;
            drawPanel.Invalidate();
        }
    }
}